# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY WYMAGANE
# Konieczne jest podanie wartości dla każdego z tych parametrów.
# ---------------------------------------------------------------------------------------------------------------------

variable "environment" {
  description = "Nazwa środowiska, w którym będzie przeprowadzone wdrożenie"
  type        = string
}

variable "min_size" {
  description = "Minimalna liczba egzemplarzy EC2 w ASG"
  type        = number
}

variable "max_size" {
  description = "Maksymalna liczba egzemplarzy EC2 w ASG"
  type        = number
}

variable "enable_autoscaling" {
  description = "Wartość true oznacza włączenie automatycznego skalowania"
  type        = bool
}

variable "db_remote_state_bucket" {
  description = "Nazwa kubełka S3 dla zdalnych informacji o stanie bazy danych"
  type        = string
}

variable "db_remote_state_key" {
  description = "Ścieżka dostępu do zdalnych informacji o stanie bazy danych w S3"
  type        = string
}

# ---------------------------------------------------------------------------------------------------------------------
# PARAMETRY OPCJONALNE
# Te parametry mają rozsądne wartości domyślne.
# ---------------------------------------------------------------------------------------------------------------------

variable "ami" {
  description = "Obraz AMI do uruchomienia w klastrze"
  type        = string
}

variable "instance_type" {
  description = "Typ egzemplarza EC2 do uruchomienia (np. t2.micro)"
  type        = string
  default     = "t2.micro"
}

variable "server_text" {
  description = "Ciąg tekstowy zwracany przez serwer"
  default     = "Witaj, świecie"
  type        = string
}

variable "server_port" {
  description = "Numer portu używany przez serwer dla żądań HTTP"
  type        = number
  default     = 8080
}

variable "custom_tags" {
  description = "Własne tagi przeznaczone do użycia w egzemplarzach ASG"
  type        = map(string)
  default     = {}
}
